

/* Future Performance Optimizations
 - only collision detection character if it is within the bounding box of a mark
 */

/* Interesting Ideas
 - could the segment's point data be a single array that is shared between segments?
 - segment length increases with each segment drawn?
 - ball makes a drawing that it can also erase?
 */


// 
// add simulated gravity changes see: http://www.howtoprogramgames.com/2012/04/ipad-accelerometer-in-processing-js/
// add softer + harder?
//

geom g = new geom();
boolean debug = true;

ArrayList <mark> marks = new ArrayList <mark> ();
ArrayList <segment> segments = new ArrayList <segment> ();
PVector segStartPos = new PVector(0, 0);
PVector center;

int savedMillis;

character ball;

final int segment_min_length = 30;
int segment_distance_travelled = 0;

void setup() {
  size(640, 920);
  frameRate(60);
 
  center = new PVector(width/2, height/2);
  ball = new character();
}

void draw() {
  sim();
  render();
}

void sim() {
  
  int times = int((millis() - savedMillis) / 16);
  
  for(int i = 0; i <= times; i++){
    ball.sim(marks);
    savedMillis = millis();
  }
  
}

void render() {

  background(0);
  strokeWeight(4);

  if (mousePressed) renderMousePosition(); 

  // render existing marks
  for (mark m : marks) {
    for (segment s : m.segments) {

      switch(s.strength) {
      case 0:
        stroke(m.shade);
        break;

      case 1:
        stroke(0, 255, 0);
        break;

      case 2:
        stroke(255, 0, 0);
        break;
      }

      strokeWeight(4 + (s.hits * 2));
      line(s.start.x, s.start.y, s.end.x, s.end.y);
    }
  }

  // preview segment
  strokeWeight(4);
  stroke(155, 155, 0);
  for (segment s : segments) {
    line(s.start.x, s.start.y, s.end.x, s.end.y);
  }

  ball.render();

  if (debug) {
    ball.debugRender();
    ball.renderCollisions();
  }
}

void mousePressed() { // remember the starting point for our new segment
  resetSegmentStartingPoint();
}

void mouseDragged() { // create a new segment based on segment_min_length and add it to our segments ArrayList
  formSegments();
}

void mouseReleased() { // create a mark from our segments and add the mark to our marks ArrayList, clear our temp. list of segments
  if (segments.size() > 0) marks.add(saveSegmentsAsMark());
}

void keyPressed() {

  switch(key) {
  case 'd':
    debug = !debug;
    break;
  case ' ':
    //rotateGravity = !rotateGravity;
    break;
  }
}

void resetSegmentStartingPoint() {
  segStartPos = new PVector(mouseX, mouseY);
}

void formSegments() {
  segment_distance_travelled += dist(pmouseX, pmouseY, mouseX, mouseY);
  if (segment_distance_travelled >= segment_min_length) {
    segments.add( new segment(segStartPos.x, segStartPos.y, mouseX, mouseY, int(random(0, 4))) );
    resetSegmentStartingPoint();
    segment_distance_travelled = 0;
  }
}

mark saveSegmentsAsMark() {
  if (segments.size() > 0) {
    ArrayList <segment> segmentsToAdd = (ArrayList) segments.clone();
    segments.clear();
    return new mark(new ArrayList(segmentsToAdd));
  }
  return null;
}

void renderMousePosition() {
  stroke(255, 0, 0);
  line(segStartPos.x, segStartPos.y, mouseX, mouseY);
}

class character {

  final int size = 20;
  final int radius = size/2;
  final int max_vel = 10;

  PVector pos = new PVector(width/2, height/2);
  PVector prev_pos = new PVector(0, 0);
  PVector vel = new PVector(0, 0);
  PVector acc = new PVector(0, 0);
  float   dec = 0.8;
  PVector wind = new PVector(0.05, 0);
  PVector gravity = new PVector(0, 0);

  ArrayList <PVector> closestPoints = new ArrayList <PVector> ();
  ArrayList <PVector> collidedPoints = new ArrayList <PVector> ();

  float angle = 0; // calculated
  float speed = 0; // calculated

  character() {
  }

  void render() {

    if (speed >= 2) {
      float x = lerp(0, 255, norm(speed, 2, 4));
      fill(255, 255-x, 255-x);
    } else if (speed <= 2) {
      float g = lerp(0, 255, norm(speed, 0, 2));
      fill(g, 255, g);
    } else {
      fill(255);
    }

    noStroke();
    ellipse(pos.x, pos.y, size, size);
    fill(255);
    ellipse(pos.x, pos.y, size/3, size/3);
    stroke(255, 0, 0);
  }

  void debugRender() {

    noFill();
    stroke(255, 100);
    strokeWeight(20);
    rect(gravity.x * 20, gravity.y * 20, width, height);
    //line(center.x, center.y, mouseX, mouseY);

    float px = pos.x + cos(angle)*10;
    float py = pos.y + sin(angle)*10;
    strokeWeight(2);
    stroke(0, 0, 255);
    line(pos.x, pos.y, px, py);
    strokeWeight(4);
  }

  void sim(ArrayList marks) {
  
    //gravity w/ accelerometer
    
    //float accelX, accelY;
    
    //accelX = device.accelerationX;
    //accelY = device.accelerationY * -1;
    
    
    //if(accelX < 1 && accelX > -1){
    // accelX = 0;
    //}
    
    //if(accelY < 1 && accelY > -1){
    // accelY = 0;
    //}
    
    //gravity = new PVector(accelX, accelY);
    
    //gravity w/ mouse
    
    gravity = new PVector(mouseX, mouseY);
    gravity.sub(center);
    
    gravity.normalize();
    gravity.mult(0.3);

    //line(width/2, height/2, mouse.x, mouse.y);

    // apply forces and do collision detection
    prev_pos = pos.get();
    isCollidingWithMark(marks);
    applyForce(gravity);
    vel.add(acc);
    vel.limit(max_vel);
    pos.add(vel);
   
    //boundary check
    if (pos.x > width - radius || pos.x < 0 + radius) {
      vel.x = vel.x * -dec;
      angle -= PI;
    }

    if (pos.y > height - radius || pos.y < 0 + radius) {
      vel.y = vel.y * -dec;
      angle -= PI;
    }
   
    if (pos.x > width - radius) {
      pos.x = width - radius;
    } else if (pos.x < 0 + radius) {
      pos.x = radius;
    }

    if (pos.y > height - radius) {
      pos.y = height - radius;
    } else if (pos.y < 0 + radius) {
      pos.y = radius;
    }

    acc.mult(0);

    angle = atan2(pos.y - prev_pos.y, pos.x - prev_pos.x);
    speed = vel.mag();
  }

  void applyForce(PVector force) {
    PVector f = force.get();
    f.div(size);
    acc.add(f);
  }

  boolean isCollidingWithMark(ArrayList <mark> marks) {

    closestPoints.clear();
    collidedPoints.clear();

    for (mark m: marks) {
      for (segment s: m.segments) {
        closestPoints.add(g.closestPointFromLineSegment(s.start, s.end, pos));
        PVector velChange = g.testCircleSegment(s.start, s.end, pos, size);  

        if (velChange != null) {  

          boolean isHit = false;

          if (speed >= 3 && s.strength == 2) {
            isHit = true;
          } else if (speed <= 1.5 && s.strength == 1) {
            isHit = true;
          } else if (s.strength == 0) {
            isHit = true;
          }

          if (isHit) {
            s.hits--;
            if (s.hits < 0) m.segments.remove(s);
          }

          collidedPoints.add(closestPoints.get(closestPoints.size()-1));
          velChange.mult(speed);
          vel.mult(0);
          acc.sub(velChange);

          return true;
        }
      }
    }
    return false;
  }

  void renderCollisions() {
    for (PVector p : closestPoints) {
      stroke(0, 0, 255);
      point(p.x, p.y);
      stroke(255);
    }
    for (PVector p : collidedPoints) {
      noStroke();
      fill(0, 0, 255);
      ellipse(p.x, p.y, 30, 30);
      fill(255);
      stroke(255);
    }
  }
}

class geom {

  geom() {
  }

  PVector closestPointFromLineSegment(PVector A, PVector B, PVector X)
  {
    PVector v = PVector.sub(B, A);
    PVector w = PVector.sub(X, A);
    float wDotv = w.dot(v);
    float t = w.dot(v) / v.dot(v);
    t = constrain(t, 0, 1);
    return PVector.add(A, PVector.mult(v, t));
  }


  PVector testCircleSegment(PVector A, PVector B, PVector X, int size)
  {
    PVector P = closestPointFromLineSegment(A, B, X);
    float distance = dist(X.x, X.y, P.x, P.y);
    if (distance <= size/2) {
      PVector newVec = PVector.sub(P, X);
      newVec.normalize();
      return newVec;
    }
    return null;
  }
}

//getVectorfromDistanceAndAngle(PVector origin, float distance, float angle){


//}

class mark {
 
  ArrayList <segment> segments;
  color shade;
 
  mark(ArrayList <segment> segs) {
    segments = segs;
    shade = color(255);
  }
  
}
class segment {
 
 PVector start, end;
 int hits;
 int strength;
  
 segment(float x1, float y1, int x2, int y2, int h) {
   start = new PVector(x1, y1);
   end = new PVector(x2, y2);
   hits = h;
   strength = int(random(0, 3));
 }
  
}

